/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import jclass.bwt.BWTUtil;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCAdjustable;
import jclass.bwt.JCAdjustmentEvent;
import jclass.bwt.JCAdjustmentListener;
import jclass.bwt.JCArrowButton;
import jclass.bwt.JCContainer;
import jclass.bwt.JCScrolledWindow;
import jclass.bwt.ScrollbarConverter;
import jclass.bwt.ScrollbarThumb;
import jclass.util.JCEnvironment;
import jclass.util.JCImageCreator;
import jclass.util.JCVector;

public class JCScrollbar
extends JCContainer
implements JCAdjustable,
JCActionListener {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    protected transient JCScrolledWindow scrolled_window;
    protected JCArrowButton incr_arrow;
    protected JCArrowButton decr_arrow;
    protected ScrollbarThumb thumb;
    static final int MIN_SLIDERSIZE = 8;
    private static final String base = "scrollbar";
    private static int nameCounter;
    int value;
    int min;
    int max = 100;
    int dir = -999;
    protected JCVector adjustmentListeners = new JCVector(0);
    int line_incr = 10;
    int page_incr = 10;
    long filter_time;
    long last_time;
    int visible;
    int major;
    int minor;
    int trough_size;
    int slider_size;
    transient Image disabled_image;
    private int dragStart = -999;
    private int dragValueStart = -999;
    private transient JCImageCreator creator;
    private transient boolean new_bg = true;
    private final String[] disabled_pixels = new String[]{"wbwbwbwbwbwbwbwb", "bwbwbwbwbwbwbwbw", "wbwbwbwbwbwbwbwb", "bwbwbwbwbwbwbwbw", "wbwbwbwbwbwbwbwb", "bwbwbwbwbwbwbwbw", "wbwbwbwbwbwbwbwb", "bwbwbwbwbwbwbwbw", "wbwbwbwbwbwbwbwb", "bwbwbwbwbwbwbwbw"};

    public JCScrollbar() {
        this(1);
    }

    public JCScrollbar(int n) {
        this(n, null, null);
    }

    public JCScrollbar(int n, Applet applet, String string) {
        super(applet, string);
        if (string == null) {
            this.setName(base + nameCounter++);
        }
        this.setLayout(null);
        this.setOrientation(n);
        this.thumb = new ScrollbarThumb(this);
        this.add(this.thumb);
        this.double_buffer = true;
        this.enable11Events(32L);
        if (this.getClass().getName().equals("jclass.bwt.JCScrollbar")) {
            this.getParameters(applet);
        }
    }

    public JCScrollbar(int n, int n2, int n3, int n4, int n5) {
        this(n);
        this.setValues(n2, n3, n4, n5);
    }

    protected void getParameters() {
        super.getParameters();
        ScrollbarConverter.getParams(this);
    }

    public void getParameters(Applet applet) {
        this.getParameters();
    }

    String getParam(String string) {
        return JCContainer.conv.getParam(this.applet, this, this.getName(), string);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public int getOrientation() {
        return this.dir;
    }

    public synchronized void setOrientation(int n) {
        ScrollbarConverter.checkOrientation(n);
        if (this.dir == n) {
            return;
        }
        this.dir = n;
        int n2 = n == 0 ? 0 : 10;
        this.decr_arrow = new JCArrowButton(n2, this.applet, this.getName());
        this.add(this.decr_arrow);
        this.decr_arrow.addActionListener(this);
        n2 = n == 0 ? 2 : 9;
        this.incr_arrow = new JCArrowButton(n2, this.applet, this.getName());
        this.add(this.incr_arrow);
        this.incr_arrow.addActionListener(this);
        this.decr_arrow.shadow = 2;
        this.incr_arrow.shadow = 2;
        this.incr_arrow.border_color = this.decr_arrow.border_color = Color.black;
    }

    public synchronized int getValue() {
        return this.value;
    }

    int check(int n) {
        return Math.min(Math.max(this.min, n), this.max - this.visible);
    }

    public synchronized void setValue(int n) {
        if ((n = this.check(n)) != this.value) {
            this.value = n;
            this.moveThumb();
        }
    }

    public synchronized void setValue(int n, boolean bl) {
        this.setValue(n, 605, bl);
    }

    synchronized void setValue(int n, int n2, boolean bl) {
        if ((n = this.check(n)) == this.value) {
            return;
        }
        this.value = n;
        this.moveThumb();
        if (!bl || this.adjustmentListeners.size() == 0) {
            return;
        }
        switch (n2) {
            case 601: {
                n2 = 2;
                break;
            }
            case 602: {
                n2 = 1;
                break;
            }
            case 603: {
                n2 = 3;
                break;
            }
            case 604: {
                n2 = 4;
                break;
            }
            case 605: {
                n2 = 5;
                break;
            }
        }
        JCAdjustmentEvent jCAdjustmentEvent = new JCAdjustmentEvent(this, 601, n2, n);
        int n3 = 0;
        while (n3 < this.adjustmentListeners.size()) {
            ((JCAdjustmentListener)this.adjustmentListeners.elementAt(n3)).adjustmentValueChanged(jCAdjustmentEvent);
            ++n3;
        }
    }

    public int getMinimum() {
        return this.min;
    }

    public synchronized void setMinimum(int n) {
        this.setValues(this.value, this.visible, n, this.max);
    }

    public int getMaximum() {
        return this.max;
    }

    public synchronized void setMaximum(int n) {
        this.setValues(this.value, this.visible, this.min, n);
    }

    public int getVisibleAmount() {
        return this.visible;
    }

    public int getVisible() {
        return this.visible;
    }

    public synchronized void setVisibleAmount(int n) {
        this.setValues(this.value, n, this.min, this.max);
    }

    public void setUnitIncrement(int n) {
        this.line_incr = n;
    }

    public int getUnitIncrement() {
        return this.line_incr;
    }

    public void setBlockIncrement(int n) {
        this.page_incr = n;
    }

    public int getBlockIncrement() {
        return this.page_incr;
    }

    public synchronized void setValues(int n, int n2, int n3, int n4) {
        if (n4 < n3) {
            n4 = n3;
        }
        n2 = Math.min(n4 - n3, n2);
        if (this.value != (n = Math.min(Math.max(n3, n), n4 - n2)) || this.visible != n2 || this.min != n3 || this.max != n4) {
            this.min = n3;
            this.max = n4;
            this.value = n;
            this.page_incr = this.visible = n2;
            this.layout();
        }
    }

    public boolean atEnd() {
        return this.value == 0 || this.value >= this.max - this.visible;
    }

    boolean dragging() {
        return this.dragStart != -999;
    }

    public long getFilterTime() {
        return this.filter_time;
    }

    public void setFilterTime(long l) {
        this.filter_time = l;
    }

    protected int preferredWidth() {
        if (this.getOrientation() == 1) {
            return 16;
        }
        return 100;
    }

    protected int preferredHeight() {
        if (this.getOrientation() == 0) {
            return 16;
        }
        return 100;
    }

    public void addAdjustmentListener(JCAdjustmentListener jCAdjustmentListener) {
        this.adjustmentListeners.add(jCAdjustmentListener);
    }

    public void removeAdjustmentListener(JCAdjustmentListener jCAdjustmentListener) {
        this.adjustmentListeners.removeElement(jCAdjustmentListener);
    }

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (jCActionEvent.getSource() == this.decr_arrow) {
            this.setValue(this.value - this.line_incr, 601, true);
            return;
        }
        if (jCActionEvent.getSource() == this.incr_arrow) {
            this.setValue(this.value + this.line_incr, 602, true);
        }
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.dragging()) {
            int n3 = this.value;
            this.value = -999;
            this.setValue(n3, 605, true);
        }
        this.dragValueStart = -999;
        this.dragStart = -999;
        if (this.scrolled_window != null && JCEnvironment.getJavaVersion() < 110) {
            this.scrolled_window.getViewport().requestFocus();
        }
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        int n3;
        if (event.target != this) {
            return true;
        }
        if (event.when - this.last_time < 20L) {
            return true;
        }
        this.last_time = event.when;
        int n4 = this.dir == 0 ? n : n2;
        int n5 = n3 = this.dir == 0 ? this.thumb.location().x : this.thumb.location().y;
        if (n4 >= n3 && n4 <= n3 + this.slider_size) {
            this.dragStart = n4;
            this.dragValueStart = this.value;
            return true;
        }
        if (event.controlDown()) {
            if (n4 < n3) {
                this.setValue(this.min, 605, true);
            } else {
                this.setValue(this.max - this.visible, 605, true);
            }
            return true;
        }
        if (n4 < n3) {
            this.setValue(this.value - this.page_incr, 603, true);
        } else {
            this.setValue(this.value + this.page_incr, 604, true);
        }
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        boolean bl;
        if (!this.dragging()) {
            return true;
        }
        int n3 = this.dir == 0 ? event.x : event.y;
        boolean bl2 = bl = event.when - this.last_time > this.filter_time;
        if (bl) {
            this.last_time = event.when;
        }
        this.setValue(this.dragValueStart + this.toValue(n3 - this.dragStart), bl);
        this.last_time = event.when;
        return true;
    }

    public boolean keyDown(Event event, int n) {
        if (n == 1002) {
            this.setValue(this.value - this.page_incr, 603, true);
            return true;
        }
        if (n == 1003) {
            this.setValue(this.value + this.page_incr, 604, true);
            return true;
        }
        if (n == 1000) {
            this.setValue(this.min, 605, true);
            return true;
        }
        if (n == 1001) {
            this.setValue(this.max - this.slider_size, 605, true);
            return true;
        }
        if (n == 1004 || n == 1006) {
            this.setValue(this.value - this.line_incr, 601, true);
            return true;
        }
        if (n == 1005 || n == 1007) {
            this.setValue(this.value + this.line_incr, 602, true);
            return true;
        }
        return super.keyDown(event, n);
    }

    public synchronized void reshape(int n, int n2, int n3, int n4) {
        this.major = this.dir == 0 ? n3 : n4;
        this.minor = this.dir == 0 ? n4 : n3;
        super.reshape(n, n2, n3, n4);
    }

    int cvtThumbSizeToPixels(int n) {
        int n2 = 0;
        if (this.max > this.min && (n2 = this.trough_size * n / (this.max - this.min)) < 0) {
            n2 = 0;
        }
        n2 = Math.min(this.trough_size, Math.max(n2, 6));
        if (this.min >= this.max) {
            n2 = this.trough_size;
        }
        return n2;
    }

    private void moveThumb() {
        if (this.getPeer() == null) {
            return;
        }
        int n = Math.max(0, Math.min(this.toPixels(this.value - this.min), this.trough_size - this.slider_size));
        int n2 = 0;
        int n3 = 0;
        if (this.dir == 0) {
            n2 = n + this.decr_arrow.size().width;
        } else {
            n3 = n + this.decr_arrow.size().height;
        }
        this.thumb.move(n2, n3);
    }

    public synchronized void layout() {
        if (this.getPeer() == null) {
            return;
        }
        int n = Math.max(this.minor, 16);
        this.trough_size = Math.max(8, this.major) - 2 * n;
        this.slider_size = this.cvtThumbSizeToPixels(this.visible);
        if (this.dir == 0) {
            this.thumb.resize(this.slider_size, this.minor);
        } else {
            this.thumb.resize(this.minor, this.slider_size);
        }
        if (this.dir == 0) {
            this.decr_arrow.reshape(0, 0, n, this.minor);
            this.incr_arrow.reshape(this.major - n, 0, n, this.minor);
        } else {
            this.decr_arrow.reshape(0, 0, this.minor, n);
            this.incr_arrow.reshape(0, this.major - n, this.minor, n);
        }
        this.moveThumb();
        this.thumb.show(this.slider_size != this.trough_size);
        this.enable(this.slider_size != this.trough_size);
    }

    protected void paintThumb(Graphics graphics) {
        if (!this.thumb.isVisible()) {
            return;
        }
        Point point = BWTUtil.translateToParent(this, this.thumb, 0, 0);
        Dimension dimension = this.thumb.size();
        if (!this.getPaintRect().intersects(new Rectangle(point, dimension))) {
            return;
        }
        this.thumb.setDoubleBuffer(false);
        Point point2 = this.thumb.location();
        graphics.setColor(this.getBackground());
        Graphics graphics2 = graphics.create(point2.x, point2.y, dimension.width, dimension.height);
        this.thumb.paint(graphics2);
        graphics2.dispose();
        this.thumb.setDoubleBuffer(true);
    }

    public void paintInterior(Graphics graphics) {
        if (!this.decr_arrow.getBackground().equals(this.getBackground())) {
            this.decr_arrow.setBackground(this.getBackground());
            this.incr_arrow.setBackground(this.getBackground());
        }
        if (this.isEnabled()) {
            graphics.setColor(BWTUtil.brighter(this.getBackground()));
            graphics.fillRect(0, 0, this.size().width, this.size().height);
        } else {
            if (this.disabled_image == null) {
                this.disabled_image = this.createDisabledImage();
            }
            BWTUtil.wallPaper(this, graphics, this.disabled_image);
        }
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, this.size().width - 1, this.size().height - 1);
        this.paintThumb(graphics);
    }

    private int toPixels(int n) {
        if (this.max == this.min) {
            return 0;
        }
        if (n >= this.max - this.min - this.visible) {
            return this.trough_size;
        }
        int n2 = this.trough_size * n / (this.max - this.min);
        if (n2 > 0) {
            return n2;
        }
        return 0;
    }

    private int toValue(int n) {
        if (this.trough_size == 0) {
            return 0;
        }
        return n * (this.max - this.min) / this.trough_size;
    }

    public synchronized void setForeground(Color color) {
        this.incr_arrow.setForeground(color);
        this.decr_arrow.setForeground(color);
        super.setForeground(color);
    }

    public synchronized void setBackground(Color color) {
        this.new_bg = this.getPeer() == null || color == null || !color.equals(this.getBackground());
        this.thumb.setBackground(color);
        super.setBackground(color);
    }

    private Image createDisabledImage() {
        if (!this.new_bg && this.disabled_image != null) {
            return this.disabled_image;
        }
        if (this.creator == null) {
            this.creator = new JCImageCreator(this);
        }
        Color color = this.getBackground();
        this.getForeground();
        this.creator.setColor('b', !color.equals(Color.white) ? color : Color.lightGray);
        this.creator.setColor('w', Color.white);
        this.new_bg = false;
        this.creator.setSize(this.disabled_pixels[0].length(), this.disabled_pixels.length);
        return this.creator.create(this.disabled_pixels);
    }

    public final void setLayout(LayoutManager layoutManager) {
    }
}

